// Used in debug builds to output logging messages
#ifdef DBG

#include "DynCache.h"

// Output debug message given a printf-style string
void DebugMessage(LPWSTR wszPrintString, ... )
{
   va_list arg_list;
   WCHAR wszFinalString[MAX_PATH];

   if (wszPrintString == NULL)
   {
        return;
   }
   
   // Convert variable parameters to one text string
   va_start(arg_list, wszPrintString);
   vswprintf_s(wszFinalString, MAX_PATH, wszPrintString, arg_list);
   va_end(arg_list);

   // Send debug output
   OutputDebugString(wszFinalString);
}


// Output debug message given error code
void DebugError(DWORD dwError)
{
	WCHAR wszDebugMsgBuf[MAX_PATH];
	WCHAR wszFinalString[MAX_PATH];

	StringCchPrintfW(wszFinalString, MAX_PATH, L"ERROR CODE[%d]: ", dwError);
	
	// Get formatted message
	FormatMessageW(FORMAT_MESSAGE_FROM_SYSTEM ,
		NULL,
		dwError,
		MAKELANGID(LANG_ENGLISH, SUBLANG_ENGLISH_US), 
		wszDebugMsgBuf,
		MAX_PATH,
		NULL );

	wcscat_s(wszFinalString, MAX_PATH, wszDebugMsgBuf);
	wcscat_s(wszFinalString, MAX_PATH, L"\n");

	// Output formatted message
	OutputDebugString(wszFinalString);
}

#endif